<?php

/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ClientDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @Return Client
     */
    public function load($id);

    /**
     * Get all records from table
     */
    public function queryAll();

    /**
     * Get all records from table ordered by field
     * @Param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn);

    /**
     * Delete record from table
     * @param client primary key
     */
    public function delete($clientid);

    /**
     * Insert record to table
     *
     * @param Client client
     */
    public function insert($client);

    /**
     * Update record in table
     *
     * @param Client client
     */
    public function update($client);

    /**
     * Delete all rows
     */
    public function clean();

    public function queryByClientname($value);

    public function queryByClientaddress($value);

    public function queryByClientphone($value);

    public function queryByClientmobile($value);

    public function queryByClientdebt($value);

    public function queryByClientdetails($value);

    public function queryByCondition($value);

    public function queryByClientdate($value);

    public function queryByUserid($value);

    public function queryByClientcode($value);

    public function deleteByClientname($value);

    public function deleteByClientaddress($value);

    public function deleteByClientphone($value);

    public function deleteByClientmobile($value);

    public function deleteByClientdebt($value);

    public function deleteByClientdetails($value);

    public function deleteByClientdele($value);

    public function deleteByClientdate($value);

    public function deleteByUserid($value);
}

?>